% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spork-to-plotmath.R
\name{plotmathToken}
\alias{plotmathToken}
\title{Quote a Token}
\usage{
plotmathToken(
  x,
  conditional = getOption("plotmath_conditional_quote", TRUE),
  unescape = getOption("plotmath_unescape", TRUE),
  ...
)
}
\arguments{
\item{x}{(length-one) character}

\item{conditional}{if true, return good tokens (parseable) unmodified}

\item{unescape}{whether to escape (unrecognized) backslash}

\item{...}{ignored arguments}
}
\value{
character
}
\description{
Quotes a token. Escapes single-quotes and wraps in single-quotes.
Also maps 'varepsilon' to 'epsilon', since plotmath has only the latter;
likewise 'varrho' maps to 'rho' and 'varpi' maps to 'omega1'.
}
\examples{
plotmathToken("can't")
}
\seealso{
Other plotmath: 
\code{\link{as_plotmath.spork}()},
\code{\link{as_plotmath}()},
\code{\link{goodToken}()},
\code{\link{spork_to_plotmath}()}
}
\concept{plotmath}
\keyword{internal}
