% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Networknb.R
\name{Networknb}
\alias{Networknb}
\title{Calculate spatial weights for networks based on input polygons.}
\usage{
Networknb(shape, snap = 1, queen = TRUE, method = "t")
}
\arguments{
\item{shape}{A shapefile (in a polygon type) that matches to your OD dataframe. The shape must have an "id" column to match your ids in df.}

\item{snap}{A parameter that is also used to calculate \code{spdep}'s spatial contingency (Please view documents of \link[spdep]{poly2nb} for more information).}

\item{queen}{A TRUE/FALSE input that is used to calculate \code{spdep}'s spatial contingency (Please view documents of \link[spdep]{poly2nb} for more information).}

\item{method}{A string value among "o" (origin based), "d" (destination based), and "t" (both way) which determines the way to generate Spatial Weights. The default value is "t".}
}
\value{
The result is in the form of a list which includes combinations of origin ids and destination ids.
}
\description{
Calculate spatial weights for networks based on input polygons.
}
\examples{
# Data manipulation
# Load sf polygon
\donttest{
CA_polygon <- spnaf::CA_polygon
}
# Execution of Networknb with data above and given parameters
\donttest{
nnb <- Networknb(shape = CA_polygon, queen = TRUE, snap = 1, method = 'o')
}

# check the results
\donttest{
head(nnb)
}
}
