% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficients.R
\name{spearman_brown}
\alias{spearman_brown}
\title{Calculate Spearman-brown coefficient}
\usage{
spearman_brown(x, y, fn_cor = cor, ...)
}
\arguments{
\item{x}{(vector) a numeric vector}

\item{y}{(vector) a numeric vector with compatible dimensions to x}

\item{fn_cor}{(function) a function returning a correlation coefficient}

\item{...}{Arguments passed to \code{fn_cor}}
}
\value{
(numeric) Spearman-Brown coefficient
}
\description{
Flanagon-Rulon reliability coefficient for doubling test length. Formula
obtained from
\href{https://link.springer.com/article/10.1007/s11634-015-0198-6}{(Warrens,
2015)}
}
\examples{
# Generate two variables with different means, variances and a correlation of about 0.5
library(MASS)
vars = mvrnorm(30, mu = c(0, 2), Sigma = matrix(c(5, 2, 2, 3), ncol = 2), empirical = TRUE)
# Calculate coefficient based on Pearson correlation
spearman_brown(vars[,1], vars[,2])
# Calculate coefficient based on ICC, two-way, random effects, absolute agreement, single rater
spearman_brown(vars[,1], vars[,2], short_icc, type = "ICC1", lmer = FALSE)
}
\seealso{
Other splithalfr coefficients: 
\code{\link{angoff_feldt}()},
\code{\link{assmd}()},
\code{\link{flanagan_rulon}()},
\code{\link{sdregi}()},
\code{\link{short_icc}()}
}
\concept{splithalfr coefficients}
