% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projections.R
\name{project_halfspace}
\alias{project_halfspace}
\title{Projection onto a halfspace}
\usage{
project_halfspace(x, a, b)
}
\arguments{
\item{x}{Point to project}

\item{a}{is the normal vector}

\item{b}{is the threshold}
}
\description{
\code{project_halfspace} computes the Euclidean projection of a point onto a closed half-space.
The function returns the projection onto the set
}
\examples{
set.seed(12345)
p <- 3
a <- matrix(rnorm(p),p,1)
a <- a/norm(a,'f')
b <- runif(1)
x <- matrix(rnorm(p),p,1)
y <- project_halfspace(x,a,b)
}
