% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render-jpg.r
\name{render_jpeg}
\alias{render_jpeg}
\title{Return a image (in JPEG format) of the javascript-rendered page.}
\usage{
render_jpeg(splash_obj = splash_local, url, base_url = NULL, quality = 75,
  width, height, timeout = 30, resource_timeout, wait = 0,
  render_all = TRUE, proxy, js, js_src, filters, allowed_domains,
  allowed_content_types, forbidden_content_types, viewport = "full", images,
  headers, body, http_method, save_args, load_args)
}
\arguments{
\item{splash_obj}{Object created by a call to \code{\link[=splash]{splash()}}}

\item{url}{The URL to render (required)}

\item{base_url}{The base url to render the page with.}

\item{quality}{JPEG quality parameter in range from 0 to 100. Default is quality=75.}

\item{width}{Resize the rendered image to the given width/height (in pixels) keeping the aspect ratio. These are optional}

\item{height}{Resize the rendered image to the given width/height (in pixels) keeping the aspect ratio. These are optional}

\item{timeout}{A timeout (in seconds) for the render (defaults to 30). Without
reconfiguring the startup parameters of the Splash server (not this package)
the maximum allowed value for the timeout is 60 seconds.}

\item{resource_timeout}{A timeout (in seconds) for individual network requests.}

\item{wait}{Time (in seconds) to wait for updates after page is loaded (defaults to 0).}

\item{render_all}{If \code{TRUE} extend the viewport to include the whole webpage (possibly very tall) before rendering.}

\item{proxy}{Proxy profile name or proxy URL.}

\item{js}{Javascript profile name.}

\item{js_src}{JavaScript code to be executed in page context.}

\item{filters}{Comma-separated list of request filter names.}

\item{allowed_domains}{Comma-separated list of allowed domain names. If present, Splash
won’t load anything neither from domains not in this list nor from subdomains of
domains not in this list.}

\item{allowed_content_types}{Comma-separated list of allowed content types. If present,
Splash will abort any request if the response’s content type doesn’t match any of
the content types in this list. Wildcards are supported.}

\item{forbidden_content_types}{Comma-separated list of forbidden content types. If
present, Splash will abort any request if the response’s content type matches
any of the content types in this list. Wildcards are supported.}

\item{viewport}{View width and height (in pixels) of the browser viewport to render the
web page. Format is “<width>x<height>”, e.g. 800x600. Default value is "full".}

\item{images}{Whether to download images.}

\item{headers}{HTTP headers to set for the first outgoing request.}

\item{body}{Body of HTTP POST request to be sent if method is POST.}

\item{http_method}{HTTP method of outgoing Splash request.}

\item{save_args}{A list of argument names to put in cache.}

\item{load_args}{Parameter values to load from cache}
}
\value{
a \link{magick} image object
}
\description{
Return a image (in JPEG format) of the javascript-rendered page.
}
\references{
\href{http://splash.readthedocs.io/en/stable/index.html}{Splash docs}
}
\seealso{
Other splash_renderers: \code{\link{execute_lua}},
  \code{\link{render_har}}, \code{\link{render_html}},
  \code{\link{render_json}}, \code{\link{render_png}}
}
\concept{splash_renderers}
