% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spidR.R
\name{wsc.names}
\alias{wsc.names}
\title{Check spider species names.}
\usage{
wsc.names(spp)
}
\arguments{
\item{spp}{A vector with species names.}
}
\value{
If any mismatches, a matrix with species not found in WSC.
}
\description{
Check species names against the World Spider Catalogue.
}
\details{
This function will check if all species names in spp are updated according to the World Spider Catalogue (2021). If not, it returns a matrix with mismatches and closer names using fuzzy matching (Levenshtein edit distance).
}
\examples{
\dontrun{
wsc.names(spp = c("Iberesia machadonia", "Nemesia bacelari", "Amphiledorus ungoliantae"))
}
}
\references{
World Spider Catalog (2021). World Spider Catalog. Version 22.0. Natural History Museum Bern, online at http://wsc.nmbe.ch. doi: 10.24436/2.
}
