% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights_from_distance_matrix.R
\name{weights_from_distance_matrix}
\alias{weights_from_distance_matrix}
\title{Transforms a distance matrix into a matrix of weights}
\usage{
weights_from_distance_matrix(
  distance.matrix = NULL,
  distance.threshold = 0
)
}
\arguments{
\item{distance.matrix}{Distance matrix. Default: \code{NULL}.}

\item{distance.threshold}{Numeric, positive, in the range of values of \code{distance.matrix}. Distances below this value in the distance matrix are set to 0., Default: \code{0}.}
}
\value{
A weighted distance matrix.
}
\description{
Transforms a distance matrix into weights (1/distance.matrix) normalized by the row sums. Used to compute Moran's I values and Moran's Eigenvector Maps. Allows to apply a threshold to the distance matrix before computing the weights.
}
\examples{
if(interactive()){

 #loading example distance matrix
 data(distance_matrix)

 #computing matrix of weights
 distance.matrix.weights <- weights_from_distance_matrix(
   distance.matrix = distance_matrix
   )

 distance.matrix.weights

}
}
