% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_analysis.R
\name{oat_csv_result_file_analysis_from_DB}
\alias{oat_csv_result_file_analysis_from_DB}
\title{Performs a robustness analysis for simulation results stored in a database, comparing simulation behaviour at different parameter values}
\usage{
oat_csv_result_file_analysis_from_DB(db_results, parameters, baseline,
  measures, PMIN, PMAX, PINC)
}
\arguments{
\item{db_results}{Set of experimental results from a mysql database}

\item{parameters}{Simulation parameters of interest}

\item{baseline}{Baseline/Calibrated values for each of those parameters}

\item{measures}{Simulation output responses}

\item{PMIN}{Minimum value of each of the parameters in sampling}

\item{PMAX}{Maximum valuer of each of the parameters in sampling}

\item{PINC}{Increment value applied in sampling}
}
\value{
A-Test scores for all parameter values and measure pairings
}
\description{
This method takes results mined from a database (like spartanDB produces)
and analyses the impact that a change in a single parameter value has had
on simulation response. This is performed by comparing the distribution of
responses for a perturbed parameter condition with the distribution under
baseline/calibrated conditions. This produces a A-Test statistics that are
returned for storing in the results database by the spartanDB package.
}
