% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aleatory_analysis.R
\name{get_medians_for_size_subsets}
\alias{get_medians_for_size_subsets}
\title{For a given sample size, get the median results to summarise results for all sets}
\usage{
get_medians_for_size_subsets(FILEPATH, NUMSUBSETSPERSAMPLESIZE, SAMPLESIZE,
  MEASURES, RESULTFILENAME, ALTFILENAME, OUTPUTFILECOLSTART,
  OUTPUTFILECOLEND)
}
\arguments{
\item{FILEPATH}{Directory where the results of the simulation runs, in folders or in single CSV file format, can be found}

\item{NUMSUBSETSPERSAMPLESIZE}{Number of run subsets for this sample size, typically 20}

\item{SAMPLESIZE}{Current sample size being processed}

\item{MEASURES}{An array containing the names of the simulation output measures to be analysed.}

\item{RESULTFILENAME}{Name of the simulation results file. In the current version, XML and CSV files can be processed. If performing this analysis over multiple timepoints, it is assumed that the timepoint follows the file name, e.g. trackedCells_Close_12.csv.}

\item{ALTFILENAME}{In some cases, it may be relevant to read from a further results file if the initial file contains no results. This filename is set here. In the current version, XML and CSV files can be processed.}

\item{OUTPUTFILECOLSTART}{Column number in the simulation results file where output begins - saves (a) reading in unnecessary data, and (b) errors where the first column is a label, and therefore could contain duplicates.}

\item{OUTPUTFILECOLEND}{Column number in the simulation results file where the last output measure is.}
}
\value{
Summary statistics for all runs under this sample size
}
\description{
For a given sample size, get the median results to summarise results for all sets
}
