% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efast_analysis.R
\name{efast_get_overall_medians}
\alias{efast_get_overall_medians}
\title{Calculates the summary stats for each parameter set (median of any
replicates)}
\usage{
efast_get_overall_medians(FILEPATH, NUMCURVES, PARAMETERS, NUMSAMPLES,
  MEASURES, TIMEPOINTS = NULL, TIMEPOINTSCALE = NULL,
  current_time = NULL, check_done = FALSE)
}
\arguments{
\item{FILEPATH}{Directory where the simulation runs can be found, in folders
or in CSV file format}

\item{NUMCURVES}{The number of 'resamples' to perform (see eFAST
documentation) - recommend using at least 3}

\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples will be generated}

\item{NUMSAMPLES}{The number of parameter subsets that were generated in
the eFAST design}

\item{MEASURES}{Array containing the names of the output measures which
are used to analyse the simulation}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing
multiple simulation timepoints. If only analysing one timepoint, this
should be set to NULL. If not, this should be an array of timepoints,
e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Sets the scale of the timepoints being analysed,
e.g. "Hours"}

\item{current_time}{If multiple timepoints, the current timepoint being processed}

\item{check_done}{If multiple timepoints, whether the input has been checked}
}
\description{
This method produces a summary of the results for a particular resampling
curve.  This shows, for each parameter of interest, the median of each
simulation output measure for each of the 65 parameter value sets generated.
Here's an example. We examine resampling curve 1, and firstly examine
parameter 1. For this parameter of interest, a number of different parameter
value sets were generated from the frequency curves (lets say 65), thus we
have 65 different sets of simulation results. The method
\code{efast_generate_medians_for_all_parameter_subsets} produced a summary
showing the median of each output measure for each run. Now, this method
calculates the median of these medians, for each output measure, and stores
these in the summary. Thus, for each parameter of interest, the medians of
each of the 65 sets of results are stored. The next parameter is then
examined, until all have been analysed. This produces a snapshot showing
the median simulation output for all parameter value sets generated for
the first resample curve. These are stored with the file name
Curve[Number]_Results_Summary in the directory specified in FILEPATH.
Again this can be done recursively for a number of timepoints if required.
}
