% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norms.R
\name{zero_norm}
\alias{zero_norm}
\alias{one_norm}
\alias{two_norm}
\alias{grouped_zero_norm}
\alias{grouped_one_norm}
\alias{grouped_two_norm}
\alias{grouped_sp_norm}
\alias{gr_one_norm}
\alias{gr_two_norm}
\alias{sp_group_norm}
\title{Calculate common norms}
\usage{
zero_norm(x)

one_norm(x)

two_norm(x)

grouped_zero_norm(x, gr)

grouped_one_norm(x, gr)

grouped_two_norm(x, gr)

grouped_sp_norm(x, gr, asparse)

gr_one_norm(x, gr)

gr_two_norm(x, gr)

sp_group_norm(x, gr, asparse = 0.05)
}
\arguments{
\item{x}{A numeric vector.}

\item{gr}{An integer (or factor) vector of the same length as x.}

\item{asparse}{Scalar. The weight to put on the l1 norm when calculating the
group norm.}
}
\value{
A numeric scalar or vector
}
\description{
Calculate different norms of vectors with or without grouping structures.
}
\section{Functions}{
\itemize{
\item \code{zero_norm()}: l0-norm (number of nonzero entries).

\item \code{one_norm()}: l1-norm (Absolute-value norm).

\item \code{two_norm()}: l2-norm (Euclidean norm).

\item \code{grouped_zero_norm()}: A vector of group-wise l0-norms.

\item \code{grouped_one_norm()}: A vector of group-wise l1-norms.

\item \code{grouped_two_norm()}: A vector of group-wise l2-norms.

\item \code{grouped_sp_norm()}: A vector of length \code{unique(gr)} consisting of
the \code{asparse} convex combination of the l1 and l2-norm for each group.

\item \code{gr_one_norm()}: The l1-norm norm of a vector (a scalar).

\item \code{gr_two_norm()}: The sum of the group-wise l2-norms of a vector
(a scalar).

\item \code{sp_group_norm()}: The sum of the \code{asparse} convex combination of
group l1 and l2-norms vectors (a scalar).

}}
\examples{
x <- c(rep(-1, 5), rep(0, 5), rep(1,5))
gr <- c(rep(1,5), rep(2,5), rep(3,5))
asparse <- 0.05
grouped_sp_norm(x, gr, asparse)

}
