% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplitude.R
\name{flatEnv}
\alias{flatEnv}
\alias{compressor}
\title{Flat envelope / compressor}
\usage{
flatEnv(
  x,
  samplingRate = NULL,
  scale = NULL,
  compression = 1,
  method = c("hil", "rms", "peak")[1],
  windowLength = 50,
  windowLength_points = NULL,
  killDC = FALSE,
  dynamicRange = 40,
  reportEvery = NULL,
  cores = 1,
  saveAudio = NULL,
  plot = FALSE,
  savePlots = NULL,
  col = "blue",
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)

compressor(
  x,
  samplingRate = NULL,
  scale = NULL,
  compression = 1,
  method = c("hil", "rms", "peak")[1],
  windowLength = 50,
  windowLength_points = NULL,
  killDC = FALSE,
  dynamicRange = 40,
  reportEvery = NULL,
  cores = 1,
  saveAudio = NULL,
  plot = FALSE,
  savePlots = NULL,
  col = "blue",
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{x}{path to a folder, one or more wav or mp3 files c('file1.wav',
'file2.mp3'), Wave object, numeric vector, or a list of Wave objects or
numeric vectors}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{scale}{maximum possible amplitude of input used for normalization of
input vector (only needed if \code{x} is a numeric vector)}

\item{compression}{the amount of compression to apply: 0 = none, 1 = maximum}

\item{method}{hil = Hilbert envelope, rms = root mean square amplitude, peak
= peak amplitude per window}

\item{windowLength}{the length of smoothing window, ms}

\item{windowLength_points}{the length of smoothing window, points. If
specified, overrides \code{windowLength}}

\item{killDC}{if TRUE, dynamically removes DC offset or similar deviations of
average waveform from zero (see examples)}

\item{dynamicRange}{parts of sound quieter than \code{-dynamicRange} dB will
not be amplified}

\item{reportEvery}{when processing multiple inputs, report estimated time
left every ... iterations (NULL = default, NA = don't report)}

\item{cores}{number of cores for parallel processing}

\item{saveAudio}{full path to the folder in which to save the compressed
sound(s)}

\item{plot}{if TRUE, plots the original sound, the smoothed envelope, and
the compressed sound}

\item{savePlots}{full path to the folder in which to save the plots (NULL =
don't save, '' = same folder as audio)}

\item{col}{the color of amplitude contours}

\item{width}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{height}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{units}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{...}{other graphical parameters passed to \code{points()} that control
the appearance of amplitude contours, eg \code{lwd, lty}, etc.}
}
\value{
If the input is a single audio (file, Wave, or numeric vector),
  returns the compressed waveform as a numeric vector with the original
  sampling rate and scale. If the input is a folder with several audio files,
  returns a list of compressed waveforms, one for each file.
}
\description{
Applies a compressor - that is, flattens the amplitude envelope of a
waveform, reducing the difference in amplitude between loud and quiet
sections. This is achieved by dividing the waveform by some function of its
smoothed amplitude envelope (Hilbert, peak or root mean square).
}
\examples{
a = rnorm(500) * seq(1, 0, length.out = 500)
b = flatEnv(a, 1000, plot = TRUE, windowLength_points = 5)    # too short
c = flatEnv(a, 1000, plot = TRUE, windowLength_points = 450)  # too long
d = flatEnv(a, 1000, plot = TRUE, windowLength_points = 100)  # about right

\dontrun{
s = soundgen(sylLen = 1000, ampl = c(0, -40, 0), plot = TRUE)
# playme(s)
s_flat1 = flatEnv(s, 16000, dynamicRange = 60, plot = TRUE,
                  windowLength = 50, method = 'hil')
s_flat2 = flatEnv(s, 16000, dynamicRange = 60, plot = TRUE,
                  windowLength = 10, method = 'rms')
s_flat3 = flatEnv(s, 16000, dynamicRange = 60, plot = TRUE,
                  windowLength = 10, method = 'peak')
# playme(s_flat2)

# Remove DC offset
s1 = c(rep(0, 50), runif(1000, -1, 1), rep(0, 50)) +
     seq(.3, 1, length.out = 1100)
s2 = flatEnv(s1, 16000, plot = TRUE, windowLength_points = 50, killDC = FALSE)
s3 = flatEnv(s1, 16000, plot = TRUE, windowLength_points = 50, killDC = TRUE)

# Compress and save all audio files in a folder
s4 = flatEnv('~/Downloads/temp2',
             method = 'peak', compression = .5,
             saveAudio = '~/Downloads/temp2/compressed',
             savePlots = '~/Downloads/temp2/compressed',
             col = 'green', lwd = 5)
osc(s4[[1]])
}
}
