% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_math.R
\name{parabPeakInterpol}
\alias{parabPeakInterpol}
\title{Parabolic peak interpolation}
\usage{
parabPeakInterpol(threePoints, plot = FALSE)
}
\arguments{
\item{plot}{if TRUE, plot the points and the fit parabola}

\item{points}{the amplitudes of three adjacent points (beta is the
peak), ideally spectrum on a dB scale, obtained with a Gaussian window}
}
\value{
Returns a list: $p = the correction coefficient in bins (idx_beta + p
  gives the true peak), $ampl_p = the amplitude of the true peak
}
\description{
Internal soundgen function
}
\details{
Takes a spectral peak and two adjacent points, fits a parabola through them,
and thus estimates true peak location relative to the discrete peak. See
https://ccrma.stanford.edu/~jos/sasp/Quadratic_Interpolation_Spectral_Peaks.html
}
\examples{
soundgen:::parabPeakInterpol(c(-1, 0, -4), plot = TRUE)
}
\keyword{internal}
