% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplitude.R
\name{getEnv}
\alias{getEnv}
\title{Get amplitude envelope}
\usage{
getEnv(sound, windowLength_points, method = c("rms", "peak", "mean", "hil")[1])
}
\arguments{
\item{sound}{input vector oscillating about zero}

\item{windowLength_points}{the length of smoothing window, points. If
specified, overrides both \code{windowLength} and \code{samplingRate}}

\item{method}{'peak' for peak amplitude per window, 'rms' for root mean
square amplitude, 'mean' for mean (for DC offset removal), 'hil' for
Hilbert}
}
\description{
Internal soundgen function
}
\details{
Returns the smoothed amplitude envelope of a waveform on the original scale.
NB: unlike seewave::env, this function returns an envelope of the same length
as the original sound, regardless of the amount of smoothing.
}
\examples{
a = rnorm(500) * seq(1, 0, length.out = 500)
windowLength_points = 50
plot(a, type = 'l')
points(soundgen:::getEnv(a, windowLength_points, 'rms'),
       type = 'l', col = 'red')
points(soundgen:::getEnv(a, windowLength_points, 'peak'),
       type = 'l', col = 'green')
points(soundgen:::getEnv(a, windowLength_points, 'hil'),
       type = 'l', col = 'blue')
points(soundgen:::getEnv(a, windowLength_points, 'mean'),
       type = 'l', lty = 3, lwd = 3)
}
\keyword{internal}
