% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formants.R
\name{addFormants}
\alias{addFormants}
\title{Add formants}
\usage{
addFormants(sound, formants, action = c("add", "remove")[1],
  vocalTract = NA, formantDep = 1, formantDepStoch = 20,
  formantWidth = 1, lipRad = 6, noseRad = 4, mouthOpenThres = 0,
  mouthAnchors = NA, interpol = c("approx", "spline", "loess")[3],
  temperature = 0.025, formDrift = 0.3, formDisp = 0.2,
  samplingRate = 16000, windowLength_points = 800, overlap = 75,
  normalize = TRUE)
}
\arguments{
\item{sound}{numeric vector with \code{samplingRate}}

\item{formants}{either a character string like "aaui" referring to default
presets for speaker "M1" or a list of formant times, frequencies,
amplitudes, and bandwidths (see ex. below). \code{formants = NA} defaults
to schwa. Time stamps for formants and mouthOpening can be specified in ms
or an any other arbitrary scale. See \code{\link{getSpectralEnvelope}} for more details}

\item{action}{'add' = add formants to the sound, 'remove' = remove formants
(inverse filtering)}

\item{vocalTract}{the length of vocal tract, cm. Used for calculating formant
dispersion (for adding extra formants) and formant transitions as the mouth
opens and closes. If \code{NULL} or \code{NA}, the length is estimated
based on specified formant frequencies (if any)}

\item{formantDep}{scale factor of formant amplitude (1 = no change relative
to amplitudes in \code{formants})}

\item{formantDepStoch}{the amplitude of additional stochastic formants added above
the highest specified formant, dB (only if temperature > 0)}

\item{formantWidth}{= scale factor of formant bandwidth (1 = no change)}

\item{lipRad}{the effect of lip radiation on source spectrum, dB/oct
(the default of +6 dB/oct produces a high-frequency boost when the mouth is
open)}

\item{noseRad}{the effect of radiation through the nose on source
spectrum, dB/oct (the alternative to \code{lipRad} when the mouth is
closed)}

\item{mouthOpenThres}{open the lips (switch from nose radiation to lip
radiation) when the mouth is more than \code{mouthOpenThres} open, 0 to 1}

\item{mouthAnchors}{a numeric vector of mouth opening (0 to 1, 0.5 = neutral,
i.e. no modification) or a dataframe specifying the time (ms) and value of
mouth opening}

\item{interpol}{the method of smoothing envelopes based on provided mouth
anchors: 'approx' = linear interpolation, 'spline' = cubic spline, 'loess'
(default) = polynomial local smoothing function. NB: this does NOT affect
the smoothing of formant anchors}

\item{temperature}{hyperparameter for regulating the amount of stochasticity
in sound generation}

\item{formDrift, formDisp}{scaling factors for the effect of temperature on
formant drift and dispersal, respectively}

\item{samplingRate}{sampling frequency, Hz}

\item{windowLength_points}{length of FFT window, points}

\item{overlap}{FFT window overlap, \%}

\item{normalize}{if TRUE, normalizes the output to range from -1 to +1}
}
\description{
A spectral filter that either adds or removes formants from a sound - that
is, amplifies or dampens certain frequency bands, as in human vowels. See
\code{\link{soundgen}} and \code{\link{getSpectralEnvelope}} for more
information. With \code{action = 'remove'} this function can perform inverse
filtering to remove formants and obtain raw glottal output, provided that you
can specify the correct formant structure.
}
\details{
Algorithm: converts input from a time series (time domain) to a spectrogram
(frequency domain) through short-term Fourier transform (STFT), multiples by
the spectral filter containing the specified formants, and transforms back to
a time series via inverse STFT. This is a subroutine in
\code{\link{soundgen}}, but it can also be used on any existing sound.
}
\examples{
sound = runif(16000)  # white noise
# playme(sound)
# spectrogram(sound, samplingRate = 16000)

# add F1 = 900, F2 = 1300 Hz
sound_filtered = addFormants(sound, formants = c(900, 1300))
# playme(sound_filtered)
# spectrogram(sound_filtered, samplingRate = 16000)

# ...and remove them again (assuming we know what the formants are)
sound_inverse_filt = addFormants(sound_filtered,
                                 formants = c(900, 1300),
                                 action = 'remove')
# playme(sound_inverse_filt)
# spectrogram(sound_inverse_filt, samplingRate = 16000)
}
