% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateTimeShift.R
\name{generateTimeShift}
\alias{generateTimeShift}
\title{Generated time-shifted versions of a Wave-like object}
\usage{
generateTimeShift(
  wave,
  type = "silent",
  amount = c(1, 2),
  where = "start",
  output = "list"
)
}
\arguments{
\item{wave}{A Wave-like object or list of Wave-like objects.}

\item{type}{The type of time-shift to apply. Either "silent" or "rotate".}

\item{amount}{Vector of amount of time to shift by (seconds).}

\item{where}{Where to insert silence if \code{type} is "silent".}

\item{output}{Return a list.}
}
\value{
A Wave-like object or list of Wave-like objects.
}
\description{
Given a Wave-like object (or list of Wave-like objects), this function generates
time-shifted versions of the object. The time-shifted versions are generated by
adding a constant amount of time to the start or end of the object. This is achieved
by either inserting silence and truncating the object to the original length, or by
rotating the audio within the object.
}
