\name{HDdata}
\alias{HDdata}
\docType{data}
\title{
half diallel data for corn hybrids
}
\description{
This dataset contains phenotpic data for 21 corn hybrids, with 2 technical repetitions, coming from a half diallel design and evaluated for sugar content. The column geno indicates the hybrid and male and female origin columns are included as well. Since there's 2 technical reps the error variance obtained by REML/ML has to be divided over 2. 

}
\usage{data("HDdata")}
\format{
  The format is:
 chr "HDdata"
}
\source{
This data was generated by a corn study.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

}
\examples{
####=========================================####
#### For CRAN time limitations most lines in the 
#### examples are silenced with one '#' mark, 
#### remove them and run the examples
####=========================================####
data(HDdata)
head(HDdata)

####=========================================####
#### GCA matrix for half diallel using male and female columns
#### use the 'hdm' function to create the half diallel matrix
####=========================================####
Z1 <- overlay(HDdata[,c("male","female")])

####=========================================####
#### SCA matrix
####=========================================####
Z2 <- model.matrix(~as.factor(geno)-1, data=HDdata)

####=========================================####
#### Define response variable and run
####=========================================####
y <- HDdata$sugar
ETA <- list(GCA=list(Z=Z1), SCA=list(Z=Z2)) # Zu component
modHD <- mmer(Y=y, Z=ETA)
summary(modHD)

####=========================================####
  #### Example 2
  #### using overlay with mmer2 function
  ####=========================================####
  # data(HDdata)
  # head(HDdata)
  # HDdata$female <- as.factor(HDdata$female)
  # HDdata$male <- as.factor(HDdata$male)
  # HDdata$geno <- as.factor(HDdata$geno)
  # #### model using overlay
  # modh <- mmer2(sugar~1, random=~female + and(male) + geno, 
  #               data=HDdata)
  # summary(modh)
  # #### model using overlay [and(.)] and covariance structures [g(.)]
  # A <- diag(7); A[1,2] <- 0.5; A[2,1] <- 0.5 # fake covariance structure
  # colnames(A) <- as.character(1:7); rownames(A) <- colnames(A);A
  # 
  # modh2 <- mmer2(sugar~1, random=~g(female) + and(g(male)) + geno, 
  #               G=list(female=A, male=A),data=HDdata)
  # summary(modh2)
}
\keyword{datasets}
\seealso{The core function of the package \code{\link{mmer}}}
