% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spaceTransformation.R
\name{space_transformation}
\alias{space_transformation}
\title{Space transformation wrapper}
\usage{
space_transformation(dataset, method, exclude = NULL, ...)
}
\arguments{
\item{dataset}{we want to do space transformation on}

\item{method}{selected method for space transformation}

\item{exclude}{\code{character}. Vector of attributes to exclude from the
space transformation process}

\item{...}{Further arguments for \code{method}}
}
\value{
The transformed dataset
}
\description{
Space transformation wrapper
}
\examples{
library("smartdata")
data(ecoli1, package = "imbalance")
data(AntibioticSmall, package = "adaptiveGPCA")
antibiotics <- data.frame(AntibioticSmall$X)

super_ecoli <- space_transformation(ecoli1, "lle_knn", k = 3, num_features = 2,
                                   regularization = 1, exclude = c("Mcg", "Alm1"))
\donttest{
super_ecoli <- space_transformation(ecoli1, "lle_epsilon", epsilon = 0.99, num_features = 3)

super_antibiotics <- space_transformation(antibiotics, "adaptative_gpca",
                                         similarity = AntibioticSmall$Q,
                                         num_features = 2)
}

}
