% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMovResHan.R
\name{rMRH}
\alias{rMRH}
\title{Sampling from a Moving-Resting-Handling Process with Embedded Brownian Motion}
\usage{
rMRH(time, lamM, lamR, lamH, sigma, p, s0, dim = 2, state = FALSE)
}
\arguments{
\item{time}{time points at which observations are to be simulated}

\item{lamM}{rate parameter of the exponential duration while moving}

\item{lamR}{rate parameter of the exponential duration while resting}

\item{lamH}{rate parameter of the exponential duration while handling}

\item{sigma}{volatility parameter of the Brownian motion while moving}

\item{p}{probability of choosing resting,
and 1-p is probability of choosing handling}

\item{s0}{the state at time 0, must be one of "m" (moving), "r" (resting) or "h" (handling).}

\item{dim}{(integer) dimension of the Brownian motion}

\item{state}{indicates whether the simulation show the states at given
time points.}
}
\value{
A \code{data.frame} whose first column is the time points and whose
other columns are coordinates of the locations. If \code{state} is
\code{TRUE}, the second column will be the simulation state.
}
\description{
A moving-resting-handling process consists of three states: moving, resting and handling.
The transition between the three states is modeled by an alternating
renewal process, with expenentially distributed duration.
An animal stays at the same location while resting and handling
(the choice of resting and handling depends on Bernoulli distribution),
and moves according to a Brownian motion while moving state.
The sequence of states is moving, resting or staying, moving, resting or staying ...
or versus
}
\examples{
set.seed(06269)
tgrid <- seq(0, 8000, length.out=1001)
dat <- rMRH(time=tgrid, lamM=4, lamR=0.04, lamH=0.2,
            sigma=1000, p=0.5, s0="m", dim=2)
plot(dat$time, dat$X1, type='l')
plot(dat$time, dat$X2, type='l')
plot(dat$X1,   dat$X2, type='l')

set.seed(06269) ## show the usage of state
dat2 <- rMRH(time=tgrid, lamM=4, lamR=0.04, lamH=0.2,
             sigma=1000, p=0.5, s0="m", dim=2, state=TRUE)
head(dat)
head(dat2)

}
\references{
Pozdnyakov, V., Elbroch, L.M., Hu, C., Meyer, T., and Yan, J. (2018+)
On estimation for Brownian motion governed by telegraph process with
multiple off states. <arXiv:1806.00849>
}
\seealso{
\code{\link{fitMRH}} for fitting model.
}
\author{
Chaoran Hu
}
