% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slopeOP.R
\name{slopeSN}
\alias{slopeSN}
\title{slopeSN}
\usage{
slopeSN(data, states, nbSegments = 1, constraint = "null",
  testMode = FALSE)
}
\arguments{
\item{data}{vector of data to segment: a univariate time series}

\item{states}{vector of states = set of accessible starting/ending values for segments in increasing order.}

\item{nbSegments}{the number of segments to infer}

\item{constraint}{string defining a constraint : "null", "isotonic"}

\item{testMode}{a boolean, if true the function also returns the percent of elements to scan (= ratio scanned elements vs. scanned elements if no pruning)}
}
\value{
a list of 3 elements  = (changepoints, states, globalCost). (Pruning is optional)
\describe{
\item{\code{changepoints}}{is the vector of changepoints (we return the extremal values of all segments from left to right)}
\item{\code{states}}{is the vector of successive states. states[i] is the value we inferred at position changepoints[i]}
\item{\code{globalCost}}{is a number equal to the global cost of the non-penalized change-in-slope problem. That is the value of the fit to the data ignoring the penalties for adding changes}
\item{\emph{pruning}}{is the percent of positions to consider in cost matrix Q  (returned only if testMode = TRUE)}
}
}
\description{
Segment neighborhood algorithm for change-in-slope problem with a finite number of states (beginning and ending values of each segment is restricted to a finite set of values called states).
The algorithm takes into account a continuity constraint between successive segments and infers a continuous piecewise linear signal with a given number of segments.
}
\examples{
myData <- slopeData(index = c(1,100,200,300), states = c(0,5,3,6), noise = 1)
slopeSN(data = myData, states = 0:6, nbSegments = 2)
}
