% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr_dev.R
\name{slackr_dev}
\alias{slackr_dev}
\title{Send the graphics contents of the current device to a Slack channel}
\usage{
slackr_dev(
  channels = Sys.getenv("SLACK_CHANNEL"),
  token = Sys.getenv("SLACK_TOKEN"),
  file = "plot",
  initial_comment = NULL,
  title = NULL,
  thread_ts = NULL
)
}
\arguments{
\item{channels}{Comma-separated list of channel names or IDs where the file will be shared.}

\item{token}{Authentication token bearing required scopes.}

\item{file}{prefix for filenames (defaults to \code{plot}).}

\item{initial_comment}{The message text introducing the file in specified channels.}

\item{title}{Title of file.}

\item{thread_ts}{Provide another message's ts value to upload this file as a reply. Never use a reply's ts value; use its parent instead.}
}
\value{
\code{httr} response object from \code{POST} call
}
\description{
\code{slackr_dev} sends the graphics contents of the current device to the
specified Slack channel.
}
\examples{
\dontrun{
slackr_setup()

# base
library(maps)
map("usa")
slackr_dev("#results", file = "map")

# base
barplot(VADeaths)
slackr_dev("@jayjacobs")
}
}
\references{
\url{https://github.com/mrkaye97/slackr/pull/12/files}
}
\seealso{
\code{\link[=slackr_setup]{slackr_setup()}}, \code{\link[=slackr_save]{slackr_save()}}, \code{\link[=slackr_upload]{slackr_upload()}}
}
\author{
Konrad Karczewski (ctb), Bob Rudis (aut)
}
