% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skm.r
\name{dist_wlatlng}
\alias{dist_wlatlng}
\title{dist_wlatlng}
\usage{
dist_wlatlng(.lat1, .lng1, .lat2, .lng2, .measure = "mi")
}
\arguments{
\item{.lat1}{latitude of coordinate1}

\item{.lng1}{longitude of coordinate1}

\item{.lat2}{latitude of coordinate2}

\item{.lng2}{longitude of coordinate2}

\item{.measure}{- mi or km}
}
\description{
calculate distance btwn coordinate1<lat1, lng1> and coordinate2<lat2, lng2>
}
\details{
calculate the great circle distance between 2 points with Haversine formula,
 which deliberately ignores elevation differences.

 Haversine formula (from R.W. Sinnott, "Virtues of the Haversine",
 Sky and Telescope, vol. 68, no. 2, 1984, p. 159):

 dlon = lon2 - lon1

 dlat = lat2 - lat1

 a = sin^2(dlat/2) + cos(lat1) * cos(lat2) * sin^2(dlon/2)

 c = 2 * arcsin(min(1,sqrt(a)))

 d = R * c
}

