% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{skim_with}
\alias{skim_with}
\alias{skim_with_defaults}
\alias{show_skimmers}
\alias{get_skimmers}
\title{Set or add the summary functions for a particular type of data}
\usage{
skim_with(..., .list = list(), append = TRUE, drop_new = FALSE)

skim_with_defaults()

show_skimmers(which = NULL)

get_skimmers(which = NULL)
}
\arguments{
\item{...}{A list of functions, with an argument name that matches a
particular data type.}

\item{.list}{Instead of individual named entries, you can provided a list
instead. If most \code{...} arguments and \code{.list} is provided, values
in \code{.list} take precedence.}

\item{append}{Whether the provided options should be in addition to the
defaults already in \code{skim}. Default is \code{TRUE}.}

\item{drop_new}{Whether types outside of the defaults should be discarded.}

\item{which}{A character vector. One or more of the classes whose summary
functions you wish to display.}
}
\value{
When setting values, \code{invisible(NULL)}. When looking up values a
list. The names of the list match the classes that have assigned
summary functions. With \code{\link[=show_skimmers]{show_skimmers()}}, each entry in the list is a
character vector of function names. With \code{\link[=get_skimmers]{get_skimmers()}}, each entry
in the list is itself a list of named functions.
}
\description{
While skim is designed around having an opinionated set of defaults, you
can use these functions to change the summary statistics that it returns.
To do that, provide type you wish to change as an argument to this function,
along with a list of named functions that you want to use instead of the
defaults.
}
\details{
This function is not pure. It sets values in within the package environment.
This is an intentional design choice, with effects similar to setting
options in base R. By setting options here for your entire session, you
can continue to summarize using skim on its own.
}
\section{Functions}{
\itemize{
\item \code{skim_with_defaults}: Use the default functions within skim

\item \code{show_skimmers}: Access the names of the summary functions for a
class.

\item \code{get_skimmers}: Pull a list of summary functions for a class.
}}

\examples{
# Use new functions for numeric functions
skim_with(numeric = list(median = median, mad = mad), append = FALSE)
skim(faithful)

# If you want to remove a particular skimmer, set it to NULL
# This removes the inline histogram
skim_with(numeric = list(hist = NULL))
skim(faithful)

# This works with multiple skimmers. Just match names to overwrite
skim_with(numeric = list(iqr = IQR, p25 = NULL, p75 = NULL))
skim(faithful)

# Alternatively, set `append = FALSE` to replace the skimmers of a type.
skim_with(numeric = list(mean = mean, sd = sd), append = FALSE)

# Skimmers are unary functions. Partially apply arguments during assigment.
# For example, you might want to remove NA values.
skim_with(numeric = list(iqr = purrr::partial(IQR, na.rm = TRUE)))

# Or use an rlang-style formula constructor for the function
skim_with(numeric = list(med = ~median(., na.rm = TRUE)))

# Set multiple types of skimmers simultaneously
skim_with(numeric = list(mean = mean), character = list(len = length))

# Or pass the same as a list
my_skimmers <- list(numeric = list(mean = mean),
                    character = list(len = length))
skim_with(.list = my_skimmers)

# Alternatively, use rlang unquoting semantics
skim_with(!!!my_skimmers)

# Go back to defaults
skim_with_defaults()
skim(faithful)

# What are the names of the numeric skimmers?
show_skimmers("numeric")

# I want to create a set of skimmers for the hms class, using the date
# skimmers currently available.
funs <- get_skimmers()
skim_with(hms = funs$date)
}
