% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize_lme.R
\name{deff}
\alias{deff}
\title{Design effects for two-level mixed models}
\usage{
deff(n, icc = 0.05)
}
\arguments{
\item{n}{Average number of observations per grouping cluster (i.e. level-2 unit).}

\item{icc}{Assumed intraclass correlation coefficient for multilevel-model.}
}
\value{
The design effect (Variance Inflation Factor) for the two-level model.
}
\description{
Compute the design effect (also called \emph{Variance Inflation Factor})
             for mixed models with two-level design.
}
\details{
The formula for the design effect is simply \code{(1 + (n - 1) * icc)}.
}
\examples{
# Design effect for two-level model with 30 observations per
# cluster group (level-2 unit) and an assumed intraclass
# correlation coefficient of 0.05.
deff(n = 30)

# Design effect for two-level model with 24 observation per cluster
# group and an assumed intraclass correlation coefficient of 0.2.
deff(n = 24, icc = 0.2)

}
\references{
Bland JM. 2000. Sample size in guidelines trials. Fam Pract. (17), 17-20.
            \cr \cr
            Hsieh FY, Lavori PW, Cohen HJ, Feussner JR. 2003. An Overview of Variance Inflation Factors for Sample-Size Calculation. Evaluation & the Health Professions 26: 239–257. \doi{10.1177/0163278703255230}
            \cr \cr
            Snijders TAB. 2005. Power and Sample Size in Multilevel Linear Models. In: Everitt BS, Howell DC (Hrsg.). Encyclopedia of Statistics in Behavioral Science. Chichester, UK: John Wiley & Sons, Ltd. \doi{10.1002/0470013192.bsa492}
            \cr \cr
            Thompson DM, Fernald DH, Mold JW. 2012. Intraclass Correlation Coefficients Typical of Cluster-Randomized Studies: Estimates From the Robert Wood Johnson Prescription for Health Projects. The Annals of Family Medicine;10(3):235–40. \doi{10.1370/afm.1347}
}
