% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjplot_themes.R
\name{sjPlot-themes}
\alias{sjPlot-themes}
\alias{theme_sjplot}
\alias{theme_sjplot2}
\alias{theme_blank}
\alias{theme_538}
\alias{font_size}
\alias{label_angle}
\alias{legend_style}
\title{Modify plot appearance}
\usage{
theme_sjplot(base_size = 12, base_family = "")

theme_sjplot2(base_size = 12, base_family = "")

theme_blank(base_size = 12, base_family = "")

theme_538(base_size = 12, base_family = "")

font_size(title, axis_title.x, axis_title.y, labels.x, labels.y, offset.x,
  offset.y, base.theme)

label_angle(angle.x, angle.y, base.theme)

legend_style(inside, pos, justify, base.theme)
}
\arguments{
\item{base_size}{Base font size.}

\item{base_family}{Base font family.}

\item{title}{Font size for plot titles.}

\item{axis_title.x}{Font size for x-axis titles.}

\item{axis_title.y}{Font size for y-axis titles.}

\item{labels.x}{Font size for x-axis labels.}

\item{labels.y}{Font size for y-axis labels.}

\item{offset.x}{Offset for x-axis titles.}

\item{offset.y}{Offset for y-axis titles.}

\item{base.theme}{Optional ggplot-theme-object, which is needed in case multiple
functions should be combined, e.g. \code{theme_sjplot() + label_angle()}.
In such cases, use \code{label_angle(base.theme = theme_sjplot())}.}

\item{angle.x}{Angle for x-axis labels.}

\item{angle.y}{Angle for y-axis labels.}

\item{inside}{Logical, use \code{TRUE} to put legend inside the plotting area.
See also \code{pos}.}

\item{pos}{Position of the legend, if a legend is drawn.
\describe{
  \item{\emph{Legend outside plot}}{
    Use \code{"bottom"}, \code{"top"}, \code{"left"} or \code{"right"}
    to position the legend above, below, on the left or right side
    of the diagram.
  }
  \item{\emph{Legend inside plot}}{
    If \code{inside = TRUE}, legend can be placed inside
    plot. Use \code{"top left"}, \code{"top right"}, \code{"bottom left"}
    and \code{"bottom right"} to position legend in any of these corners,
    or a two-element numeric vector with values from 0-1. See also
    \code{inside}.
  }
}}

\item{justify}{Justification of legend, relative to its position (\code{"center"} or
two-element numeric vector with values from 0-1.}
}
\description{
Set default theme plots or modify plot appearance.
}
\examples{
# prepare data
library(sjmisc)
data(efc)
efc <- to_factor(efc, c161sex, e42dep, c172code)
m <- lm(neg_c_7 ~ pos_v_4 + c12hour + e42dep + c172code, data = efc)

# create plot-object
p <- plot_model(m)

# change theme
p + theme_sjplot()

# change font-size
p + font_size(axis_title.x = 30)

}
