% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotFrequencies.R
\name{sjp.frq}
\alias{sjp.frq}
\title{Plot frequencies of variables}
\usage{
sjp.frq(var.cnt, title = "", weight.by = NULL, title.wtd.suffix = NULL,
  sort.frq = c("none", "asc", "desc"), type = c("bar", "dot", "histogram",
  "line", "density", "boxplot", "violin"), geom.size = NULL,
  geom.colors = "#336699", errorbar.color = "darkred", axis.title = NULL,
  axis.labels = NULL, xlim = NULL, ylim = NULL, wrap.title = 50,
  wrap.labels = 20, grid.breaks = NULL, expand.grid = FALSE,
  show.values = TRUE, show.n = TRUE, show.prc = TRUE,
  show.axis.values = TRUE, show.ci = FALSE, show.na = FALSE,
  show.mean = FALSE, show.mean.val = TRUE, show.sd = TRUE,
  mean.line.type = 2, mean.line.size = 0.5, inner.box.width = 0.15,
  inner.box.dotsize = 3, normal.curve = FALSE, normal.curve.color = "red",
  normal.curve.size = 0.8, normal.curve.alpha = 0.4, auto.group = NULL,
  coord.flip = FALSE, vjust = "bottom", hjust = "center",
  y.offset = NULL, prnt.plot = TRUE)
}
\arguments{
\item{var.cnt}{Vector of counts, for which frequencies or means will be plotted or printed.}

\item{title}{character vector, used as plot title. Depending on plot type and function,
will be set automatically. If \code{title = ""}, no title is printed.
For effect-plots, may also be a character vector of length > 1,
to define titles for each sub-plot or facet.}

\item{weight.by}{Vector of weights that will be applied to weight all cases.
Must be a vector of same length as the input vector. Default is
\code{NULL}, so no weights are used.}

\item{title.wtd.suffix}{Suffix (as string) for the title, if \code{weight.by} is specified,
e.g. \code{title.wtd.suffix=" (weighted)"}. Default is \code{NULL}, so
title will not have a suffix when cases are weighted.}

\item{sort.frq}{Determines whether categories should be sorted
according to their frequencies or not. Default is \code{"none"}, so
categories are not sorted by frequency. Use \code{"asc"} or
\code{"desc"} for sorting categories ascending or descending order.}

\item{type}{Specifies the plot type. May be abbreviated.
\describe{
  \item{\code{"bar"}}{for simple bars (default)}
  \item{\code{"dot"}}{for a dot plot}
  \item{\code{"histogram"}}{for a histogram (does not apply to grouped frequencies)}
  \item{\code{"line"}}{for a line-styled histogram with filled area}
  \item{\code{"density"}}{for a density plot (does not apply to grouped frequencies)}
  \item{\code{"boxplot"}}{for box plot}
  \item{\code{"violin"}}{for violin plots}
  }}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size,
depending on plot type and function). Note that bar and bin widths mostly
need smaller values than dot sizes.}

\item{geom.colors}{User defined color for geoms, e.g. \code{geom.colors = "#0080ff"}.}

\item{errorbar.color}{Color of confidence interval bars (error bars).
Only applies to \code{type = "bar"}. In case of dot plots, error bars
will have same colors as dots (see \code{geom.colors}).}

\item{axis.title}{Character vector of length one or two (depending on
the plot function and type), used as title(s) for the x and y axis.
If not specified, a default labelling  is chosen. To set multiple
axis titles (e.g. with \code{type = "eff"} for many predictors),
\code{axis.title} must be a character vector of same length of plots
that are printed. In this case, each plot gets an own axis title
(applying, for instance, to the y-axis for \code{type = "eff"}).
\strong{Note:} Some plot types do not support this argument. In such
cases, use the return value and add axis titles manually with
\code{\link[ggplot2]{labs}}, e.g.: \code{$plot.list[[1]] + labs(x = ...)}}

\item{axis.labels}{character vector with labels used as axis labels. Optional
argument, since in most cases, axis labels are set automatically.}

\item{xlim}{Numeric vector of length two, defining lower and upper axis limits
of the x scale. By default, this argument is set to \code{NULL}, i.e. the
x-axis fits to the required range of the data.}

\item{ylim}{numeric vector of length two, defining lower and upper axis limits
of the y scale. By default, this argument is set to \code{NULL}, i.e. the
y-axis fits to the required range of the data.}

\item{wrap.title}{numeric, determines how many chars of the plot title are displayed in
one line and when a line break is inserted.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis
labels are displayed in one line and when a line break is inserted.}

\item{grid.breaks}{numeric; sets the distance between breaks for the axis,
i.e. at every \code{grid.breaks}'th position a major grid is being printed.}

\item{expand.grid}{logical, if \code{TRUE}, the plot grid is expanded, i.e. there is a small margin between
axes and plotting region. Default is \code{FALSE}.}

\item{show.values}{logical, whether values should be plotted or not.}

\item{show.n}{logical, if \code{TRUE}, adds total number of cases for each
group or category to the labels.}

\item{show.prc}{logical, if \code{TRUE} (default), percentage values are plotted to each bar
If \code{FALSE}, percentage values are removed.}

\item{show.axis.values}{logical, whether category, count or percentage values for the axis
should be printed or not.}

\item{show.ci}{Logical, if \code{TRUE}, depending on \code{type}, a confidence
interval or region is added to the plot.}

\item{show.na}{logical, if \code{TRUE}, \code{\link{NA}}'s (missing values)
are added to the output.}

\item{show.mean}{Logical, if \code{TRUE}, a vertical line in histograms
is drawn to indicate the mean value of the variables. Only
applies to histogram-charts.}

\item{show.mean.val}{Logical, if \code{TRUE} (default), the mean value
is printed to the vertical line that indicates the variable's
mean. Only applies to histogram-charts.}

\item{show.sd}{Logical, if \code{TRUE}, the standard deviation
is annotated as shaded rectangle around the mean intercept
line. Only applies to histogram-charts.}

\item{mean.line.type}{Numeric value, indicating the linetype of the mean
intercept line. Only applies to histogram-charts and
when \code{show.mean = TRUE}.}

\item{mean.line.size}{Numeric, size of the mean intercept line. Only
applies to histogram-charts and when \code{show.mean = TRUE}.}

\item{inner.box.width}{width of the inner box plot that is plotted inside of violin plots. Only applies
if \code{type = "violin"}. Default value is 0.15}

\item{inner.box.dotsize}{size of mean dot insie a violin or box plot. Applies only
when \code{type = "violin"} or \code{"boxplot"}.}

\item{normal.curve}{Logical, if \code{TRUE}, a normal curve, which is adjusted to the data,
is plotted over the histogram or density plot. Default is
\code{FALSE}. Only applies when histograms or density plots are plotted (see \code{type}).}

\item{normal.curve.color}{Color of the normal curve line. Only
applies if \code{normal.curve = TRUE}.}

\item{normal.curve.size}{Numeric, size of the normal curve line. Only
applies if \code{normal.curve = TRUE}.}

\item{normal.curve.alpha}{Transparancy level (alpha value) of the normal curve. Only
applies if \code{normal.curve = TRUE}.}

\item{auto.group}{numeric value, indicating the minimum amount of unique values
in the count variable, at which automatic grouping into smaller units
is done (see \code{\link[sjmisc]{group_var}}). Default value for
\code{auto.group} is \code{NULL}, i.e. auto-grouping is off.
See \code{\link[sjmisc]{group_var}} for examples on grouping.}

\item{coord.flip}{logical, if \code{TRUE}, the x and y axis are swapped.}

\item{vjust}{character vector, indicating the vertical position of value
labels. Allowed are same values as for \code{vjust} aesthetics from
\code{ggplot2}: "left", "center", "right", "bottom", "middle", "top" and
new options like "inward" and "outward", which align text towards and
away from the center of the plot respectively.}

\item{hjust}{character vector, indicating the horizontal position of value
labels. Allowed are same values as for \code{vjust} aesthetics from
\code{ggplot2}: "left", "center", "right", "bottom", "middle", "top" and
new options like "inward" and "outward", which align text towards and
away from the center of the plot respectively.}

\item{y.offset}{numeric, offset for text labels when their alignment is adjusted
to the top/bottom of the geom (see \code{hjust} and \code{vjust}).}

\item{prnt.plot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{data}).
}
\description{
Plot frequencies of a variable as bar graph, histogram,
               box plot etc.
}
\note{
This function only works with variables with integer values (or numeric
        factor levels), i.e. scales / centred variables
        with decimals may result in unexpected behaviour.
}
\examples{
# boxplot
sjp.frq(ChickWeight$weight, type = "box")

# histogram
sjp.frq(discoveries, type = "hist", show.mean = TRUE)

# violin plot
sjp.frq(ChickWeight$weight, type = "v")

# bar plot
sjp.frq(ChickWeight$Diet)


# bar plot with EUROFAMCARE sample dataset
# dataset was importet from an SPSS-file, using:
# efc <- sjmisc::read_spss("efc.sav", enc = "UTF-8")
library(sjmisc)
data(efc)
# you may use sjp.setTheme here to change axis textangle
sjp.frq(efc$e15relat)

# bar plot with EUROFAMCARE sample dataset
# grouped variable
ageGrp <- group_var(efc$e17age)
ageGrpLab <- group_labels(efc$e17age)
sjp.frq(ageGrp, title = get_label(efc$e17age), axis.labels = ageGrpLab)

# negative impact scale, ranging from 7-28
sjp.frq(efc$neg_c_7)

# plotting confidence intervals. expand grid and v/hjust for text labels
sjp.frq(efc$e15relat, type = "dot", show.ci = TRUE, sort.frq = "desc",
        coord.flip = TRUE, expand.grid = TRUE, vjust = "bottom",
        hjust = "left")

# Simulate ggplot-default histogram
sjp.frq(efc$c160age, type = "h", geom.size = 3)

# histogram with overlayed normal curve
sjp.frq(efc$c160age, type = "h", show.mean = TRUE, show.mean.val = TRUE,
        normal.curve = TRUE, show.sd = TRUE, normal.curve.color = "blue",
        normal.curve.size = 3, ylim = c(0,50))

}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/sjp.frq/}{sjPlot manual: sjp.frq}
           \item \code{\link{sjt.frq}}
         }
}
