\name{sju.adjustPlotRange.y}
\alias{sju.adjustPlotRange.y}
\title{Adjust y range of ggplot-objects}
\usage{
sju.adjustPlotRange.y(gp, upperMargin = 1.05)
}
\arguments{
  \item{gp}{A ggplot-object. Usually, this will be returned
  by most of this package's plotting functions via the
  \code{returnPlot} parameter.}

  \item{upperMargin}{Defines the margin of the upper y
  bound of the plot. This value will be multiplied with the
  total y range. Default is 1.05, which means that the
  upper margin of the plot is about 5 percent of the
  "visible" plot area (i.e. the y-range is 105 percent of
  the actual needed range to make all object visible).}
}
\value{
The same ggplot-object, with adjusted y-range, so all
graphics and labels should be visible.
}
\description{
This method adjurts the y-range of a ggplot-object, which
is useful when value labels are outside of the plot region.
A modified ggplot-object will be returned with adjusted
y-range so everything should be visible.  Note that this
function only works on \code{scale_y_continuous}.
}
\note{
Note that this function only works on
\code{scale_y_continuous}.
}
\examples{
# sample sata set
data(efc)
# show frequencies of relationship-variable and
# retrieve plot object
gp <- sjp.frq(efc$e15relat, returnPlot=TRUE)
# show current plot
plot(gp)
# show adjusted plot
sju.adjustPlotRange.y(gp)
}
\references{
\url{http://www.r-bloggers.com/setting-axis-limits-on-ggplot-charts/}
}

