% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.sits_accuracy}
\alias{plot.sits_accuracy}
\title{Plot confusion matrix}
\usage{
\method{plot}{sits_accuracy}(x, y, ..., title = "Confusion matrix")
}
\arguments{
\item{x}{Object of class "plot.sits_accuracy".}

\item{y}{Ignored.}

\item{...}{Further specifications for \link{plot}.}

\item{title}{Title of plot.}
}
\value{
A plot object produced by the ggplot2 package
                     containing color bars showing the confusion
                     between classes.
}
\description{
Plot a bar graph with informations about the confusion matrix
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # show accuracy for a set of samples
    train_data <- sits_sample(samples_modis_ndvi, frac = 0.5)
    test_data <- sits_sample(samples_modis_ndvi, frac = 0.5)
    # compute a random forest model
    rfor_model <- sits_train(train_data, sits_rfor())
    # classify training points
    points_class <- sits_classify(
        data = test_data, ml_model = rfor_model
    )
    # calculate accuracy
    acc <- sits_accuracy(points_class)
    # plot accuracy
    plot(acc)
}
}
\author{
Gilberto Camara \email{gilberto.camara@inpe.br}
}
