% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_machine_learning.R
\name{sits_svm}
\alias{sits_svm}
\title{Train support vector machine models}
\usage{
sits_svm(
  samples = NULL,
  formula = sits_formula_linear(),
  scale = FALSE,
  cachesize = 1000,
  kernel = "radial",
  degree = 3,
  coef0 = 0,
  cost = 10,
  tolerance = 0.001,
  epsilon = 0.1,
  cross = 10,
  ...
)
}
\arguments{
\item{samples}{Time series with the training samples.}

\item{formula}{Symbolic description of the model to be fit.
(default: sits_formula_linear).}

\item{scale}{Logical vector indicating the variables to be scaled.}

\item{cachesize}{Cache memory in MB (default = 1000).}

\item{kernel}{Kernel used in training and predicting.
options: "linear", "polynomial", "radial", "sigmoid"
(default: "radial").}

\item{degree}{Exponential of polynomial type kernel (default: 3).}

\item{coef0}{Parameter needed for kernels of type polynomial
and sigmoid (default: 0).}

\item{cost}{Cost of constraints violation (default: 10).}

\item{tolerance}{Tolerance of termination criterion (default: 0.001).}

\item{epsilon}{Epsilon in the insensitive-loss function
(default: 0.1).}

\item{cross}{Number of cross validation folds applied
to assess the quality of the model (default: 10).}

\item{...}{Other parameters to be passed to e1071::svm function.}
}
\value{
Model fitted to input data
                        (to be passed to \code{\link[sits]{sits_classify}})
}
\description{
This function receives a tibble with a set of attributes X
for each observation Y. These attributes are the values of the time series
for each band.
The SVM algorithm is used for multiclass-classification.
For this purpose, it uses the "one-against-one" approach,
in which k(k-1)/2 binary classifiers are trained;
the appropriate class is found by a voting scheme.
This function is a front-end to the "svm" method in the "e1071" package.
Please refer to the documentation in that package for more details.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # Example of training a model for time series classification
    # Retrieve the samples for Mato Grosso
    # train an SVM model
    ml_model <- sits_train(samples_modis_4bands, ml_method = sits_svm)
    # select the bands to classify the point
    sample_bands <- sits_bands(samples_modis_4bands)
    point_4bands <- sits_select(point_mt_6bands, bands = sample_bands)
    # classify the point
    point_class <- sits_classify(point_4bands, ml_model)
    plot(point_class)
}
}
\author{
Alexandre Ywata de Carvalho, \email{alexandre.ywata@ipea.gov.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}

Gilberto Camara, \email{gilberto.camara@inpe.br}
}
