% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ob_convertr.R
\name{ob_convertr}
\alias{ob_convertr}
\title{Convert between IOTF, WHO and CDC prevalence rates for child thinness,
overweight and obesity}
\usage{
ob_convertr(
  prev = 50,
  age,
  sex,
  from,
  to,
  prev_true = NA,
  report = c("vector", "wider", "longer"),
  plot = c("no", "density", "compare"),
  data = parent.frame()
)
}
\arguments{
\item{prev}{vector of age-sex-specific percentage prevalence rates.}

\item{age}{vector of ages between 2 and 18 years corresponding to each rate.}

\item{sex}{vector of the sexes corresponding to each rate, coded as either
'boys/girls' or 'male/female' or '1/2' (upper or lower case, and only the
first character considered).}

\item{from}{the BMI cutoff (see Details) on which the prevalence is based.}

\item{to}{the BMI cutoff (see Details) on which to base the converted
prevalence.}

\item{prev_true}{optional vector of known percentage prevalence rates
corresponding to \code{to}, for validation purposes.}

\item{report}{character controlling the format of the returned data: 'vector'
for the estimated prevalence rates, 'wider' for the working tibble in wide
format, i.e. the \code{from} and \code{to} data side by side, or 'longer'
for the tibble in long format, i.e. two rows per rate, one for \code{from}
and one for \code{to}.}

\item{plot}{character controlling what if anything is plotted: 'no' for no
plot, 'density' to display the BMI density distributions and cutoffs
corresponding to \code{from} and \code{to}, or 'compare' to display the
predicted prevalence rates plotted against the observed rates in
\code{prev_true}.}

\item{data}{data frame containing \code{prev}, \code{age}, \code{sex} and
\code{prev_true}.}
}
\value{
Either the converted prevalence rates or a plot visualizing the
  findings, depending on the \code{report} and \code{plot} settings.
}
\description{
Child thinness, overweight and obesity are defined as the child's body mass
index (BMI) lying beyond a pre-specified reference cutoff. Three references
are compared here: IOTF (International Obesity Task Force), WHO (World Health
Organization) and CDC (US Centers for Disease Control and Prevention), each
of which have their own cutoffs. \code{ob_convertr} takes age-sex-specific
prevalence rates of thinness, overweight and obesity based on one cutoff, and
converts them to rates based on a different cutoff, using a novel estimation
algorithm.
}
\details{
The IOTF cutoffs correspond to the value of BMI (kg/m^2) at age 18: IOTF35
(morbid obesity), IOTF30 (obesity), IOTF25 (overweight), IOTF18.5 (grade 1
thinness), IOTF17 (grade 2 thinness) and IOTF16 (grade 3 thinness).

The WHO cutoffs correspond to BMI z_scores. Age 5-19 years, WHO+2 (obesity),
WHO+1 (overweight) and WHO-2 (thinness). Age 0-5 years, WHO+3 (obesity),
WHO+2 (overweight) and WHO-2 (thinness).

The CDC cutoffs correspond to BMI centiles: CDC95 (obesity), CDC85
(overweight) and CDC5 (thinness).

Note 1: the overweight category needs to be analysed as overweight plus
obesity. To predict overweight excluding obesity, first calculate predicted
overweight plus obesity then subtract predicted obesity.

Note 2: the category labels are harmonised and not necessarily as originally
defined.

The conversion algorithm exploits the fact that all three references are
based on the LMS method, which allows prevalence to be converted to a common
BMI centile and z-score scale.

The algorithm is commutative, which means that converting a prevalence rate
from cutoff A to cutoff B and then from B to A returns the original value.
}
\examples{
## convert 10\% IOTF overweight prevalence (cutoff IOTF25) in 8-year-old boys
## to the overweight prevalence based on WHO, i.e. cutoff WHO+1
ob_convertr(prev = 10, age = 8, sex = 'boys', from = 'IOTF25', to = 'WHO+1')

## compare the BMI density functions and cutoffs for IOTF25 and WHO+1
ob_convertr(prev = 10, age = 8, sex = 'boys', from = 'IOTF25', to = 'WHO+1', plot = 'density')

#' ## convert IOTF overweight prevalence to WHO overweight prevalence
## and compare with true value - boys and girls age 7-17
## note the need to first add obesity prevalence to overweight prevalence
data(deren)
deren <- within(deren, {
  IOTF25 = IOTF25 + IOTF30
  `WHO+1` = `WHO+1` + `WHO+2`})
ob_convertr(prev = IOTF25, age = Age, sex = Sex, from = 'IOTF25', to = 'WHO+1',
   prev_true = `WHO+1`, data = deren, plot = 'compare')
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
