% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haystack_continuous.R
\name{haystack_continuous_highD}
\alias{haystack_continuous_highD}
\title{The main Haystack function, for higher-dimensional spaces and continuous expression levels.}
\usage{
haystack_continuous_highD(
  x,
  expression,
  grid.points = 100,
  weights.advanced.Q = NULL,
  dir.randomization = NULL,
  scale = TRUE,
  grid.method = "centroid",
  randomization.count = 100,
  n.genes.to.randomize = 100,
  selection.method.genes.to.randomize = "heavytails",
  grid.coord = NULL,
  spline.method = "ns"
)
}
\arguments{
\item{x}{Coordinates of cells in a 2D or higher-dimensional space. Rows represent cells, columns the dimensions of the space.}

\item{expression}{a matrix with expression data of genes (rows) in cells (columns)}

\item{grid.points}{An integer specifying the number of centers (grid points) to be used for estimating the density distributions of cells. Default is set to 100.}

\item{weights.advanced.Q}{(Default: NULL) Optional weights of cells for calculating a weighted distribution of expression.}

\item{dir.randomization}{If NULL, no output is made about the random sampling step. If not NULL, files related to the randomizations are printed to this directory.}

\item{scale}{Logical (default=TRUE) indicating whether input coordinates in x should be scaled to mean 0 and standard deviation 1.}

\item{grid.method}{The method to decide grid points for estimating the density in the high-dimensional space. Should be "centroid" (default) or "seeding".}

\item{randomization.count}{Number of randomizations to use. Default: 100}

\item{n.genes.to.randomize}{Number of genes to use in randomizations. Default: 100}

\item{selection.method.genes.to.randomize}{Method used to select genes for randomization.}

\item{grid.coord}{matrix of grid coordinates.}

\item{spline.method}{Method to use for fitting splines "ns" (default): natural splines, "bs": B-splines.}
}
\value{
An object of class "haystack", including the results of the analysis, and the coordinates of the grid points used to estimate densities.
}
\description{
The main Haystack function, for higher-dimensional spaces and continuous expression levels.
}
\examples{
# using the toy example of the singleCellHaystack package

# running haystack
res <- haystack(dat.tsne, dat.expression)
# list top 10 biased genes
show_result_haystack(res, n=10)
}
