% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadBasemap.R
\name{downloadBasemap}
\alias{downloadBasemap}
\title{Download basemap from Italian National Geoportal}
\usage{
downloadBasemap(
  file = file,
  xSW = 410000,
  ySW = 5000500,
  xExt = 5000,
  yExt = 5000,
  crs = 32,
  width = 1024,
  height = 1024,
  units = "px",
  res = 72
)
}
\arguments{
\item{file}{Path to output file.}

\item{xSW}{South West Easting UTM coordinate of the basemap (in metres).}

\item{ySW}{South West Northing UTM coordinate of the basemap (in metres).}

\item{xExt}{Easting extension in metres.}

\item{yExt}{Northing extension in metres.}

\item{crs}{UTM Coordinate Reference System: either 32 or 33.}

\item{width}{The basemap width.}

\item{height}{The basemap height.}

\item{units}{The unit of measure of width and height.
It can be \code{px} (pixels, the default), \verb{in} (inches), \code{cm} or \code{mm}}

\item{res}{The resolution in dpi.}
}
\value{
No value is returned.
}
\description{
This function tries to download the aerial orthophoto of the requested
domain from the
\href{http://www.pcn.minambiente.it/mattm/en/services/}{Italian National Geoportal}.
The output is given in \emph{png} format at the path given in the \code{file}
parameter.
}
\examples{
\dontrun{
# Download a basemap of a domain with SW coordinates (410000, 5000500) 
# in the UTM32 CRS and extension 5000m in both directions.

downloadBasemap(file = "./basemap.png", 
                xSW = 410000, ySW = 5000500, xExt = 5000, yExt = 5000)

# Download a basemap of a domain with SW coordinates (410000, 5000500) 
# in the UTM32 CRS and extension 5000m in both directions.
# The file has to be 2048 x 2048 pixels.

downloadBasemap(file = "./basemap.png", 
                xSW = 410000, ySW = 5000500, xExt = 5000, yExt = 5000, 
                width = 2048, height = 2048)
                
# Download a basemap of a domain with SW coordinates (410000, 5000500)
# in the UTM32 CRS and extension 5000m in both directions.
# The file has to be 10cm x 10cm with a resolution of 150 dpi.

downloadBasemap(file = "./basemap.png", 
                xSW = 410000, ySW = 5000500, xExt = 5000, yExt = 5000, 
                width = 10, height = 10, units = "cm", res = 150)
}
}
