% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotly.R
\name{plotly_col_legend}
\alias{plotly_col_legend}
\title{Change colour legend elements order.}
\usage{
plotly_col_legend(plotly, rev = FALSE, order = NULL)
}
\arguments{
\item{plotly}{A plotly object. Required input.}

\item{rev}{TRUE or FALSE of whether to reverse the order of elements.}

\item{order}{A numeric vector specifying the order of elements.}
}
\description{
Change colour legend elements order.
}
\examples{
library(dplyr)
plot_data <- dplyr::sample_frac(ggplot2::diamonds, 0.05) 

plot <- ggplot_point_col(data = plot_data, x_var = carat, y_var = price, col_var = color)

plotly::ggplotly(plot)

plotly::ggplotly(plot) \%>\% 
  plotly_col_legend(rev = TRUE)

plotly::ggplotly(plot) \%>\% 
  plotly_col_legend(order = c(2, 1, 3:7))
}
