% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_palettes.R
\name{sc_across}
\alias{sc_across}
\title{Generates a palette within across hues}
\usage{
sc_across(palette = "ROYGTBVPGy", light = 3, sat = "", return = NULL)
}
\arguments{
\item{palette}{the first letter of each hue to include}

\item{light}{the lightness value to hold constant (1:7)}

\item{sat}{the saturation value to hold constant ("bright", "muted", "dull", "")}

\item{return}{defaults to returning hex codes but can also return a table or plot of the generated palette}
}
\description{
Generates a palette within across hues
}
\examples{
sc_across(palette = "BO")
sc_across(palette = "BO", sat = "bright", return = "table")
sc_across(palette = "BO", sat = "bright", return = "plot")
sc_across(palette = "RBTVPGy", light = 4, return = "plot")
}
\seealso{
Other palettes: 
\code{\link{sc_within}()}
}
\concept{palettes}
