% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.simmr_output_tdf.R
\name{summary.simmr_output_tdf}
\alias{summary.simmr_output_tdf}
\title{Summarises the output created with \code{\link{simmr_mcmc_tdf}}}
\usage{
\method{summary}{simmr_output_tdf}(object, type = c("diagnostics",
  "quantiles", "statistics", "correlations"), ...)
}
\arguments{
\item{object}{An object of class \code{simmr_output_df} produced by the
function \code{\link{simmr_mcmc_tdf}}}

\item{type}{The type of output required. At least none of 'diagnostics',
'quantiles', 'statistics', 'correlations'}

\item{...}{Not used}
}
\value{
An list containing the following components: \item{gelman }{The
convergence diagnostics} \item{quantiles }{The quantiles of each parameter
from the posterior distribution} \item{statistics }{The means and standard
deviations of each parameter} \item{correlations }{The posterior
correlations between the parameters} Note that this object is reported
silently so will be discarded unless the function is called with an object
as in the example below.
}
\description{
Produces textual summaries and convergence diagnostics for an object created
with \code{\link{simmr_mcmc_tdf}}. The different options are: 'diagnostics'
which produces Brooks-Gelman-Rubin diagnostics to assess MCMC convergence,
'quantiles' which produces credible intervals for the parameters,
'statistics' which produces means and standard deviations, and
'correlations' which produces correlations between the parameters.
}
\details{
The quantile output allows easy calculation of 95 per cent credible
intervals of the posterior dietary proportions. The Gelman diagnostic values should be close to 1 to ensure satisfactory convergence.

Multiple groups are not currently supported for estimating TDFs.
}
\examples{
\dontrun{
## Example of estimating TDFs for a simple system with known dietary proportions

# Data set 1: 10 obs on 2 isos, 4 sources, with tefs and concdep
# Assume p = c(0.25, 0.25, 0.25, 0.25)

# The data
mix = matrix(c(-10.13, -10.72, -11.39, -11.18, -10.81, -10.7, -10.54, 
-10.48, -9.93, -9.37, 11.59, 11.01, 10.59, 10.97, 11.52, 11.89, 
11.73, 10.89, 11.05, 12.3), ncol=2, nrow=10)
colnames(mix) = c('d13C','d15N')
s_names=c('Source A','Source B','Source C','Source D')
s_means = matrix(c(-14, -15.1, -11.03, -14.44, 3.06, 7.05, 13.72, 5.96), ncol=2, nrow=4)
s_sds = matrix(c(0.48, 0.38, 0.48, 0.43, 0.46, 0.39, 0.42, 0.48), ncol=2, nrow=4)
conc = matrix(c(0.02, 0.1, 0.12, 0.04, 0.02, 0.1, 0.09, 0.05), ncol=2, nrow=4)

# Load into simmr
simmr_tdf = simmr_load(mixtures=mix,
                     source_names=s_names,
                     source_means=s_means,
                     source_sds=s_sds,
                     concentration_means = conc)

# Plot
plot(simmr_tdf)

# MCMC run
simmr_tdf_out = simmr_mcmc_tdf(simmr_tdf, 
p = matrix(rep(1/simmr_tdf$n_sources, 
simmr_tdf$n_sources),
ncol = simmr_tdf$n_sources, 
nrow = simmr_tdf$n_obs, byrow = TRUE))

# Summary
summary(simmr_tdf_out,type='diagnostics')
summary(simmr_tdf_out,type='quantiles')

# Now put these corrections back into the model and check the 
# iso-space plots and dietary output
simmr_tdf_2 = simmr_load(mixtures=mix,
                     source_names=s_names,
                     source_means=s_means,
                     source_sds=s_sds,
                     correction_means = simmr_tdf_out$c_mean_est,
                     correction_sds = simmr_tdf_out$c_sd_est,
                     concentration_means = conc)

# Plot with corrections now
plot(simmr_tdf_2)

simmr_tdf_2_out = simmr_mcmc(simmr_tdf_2)
summary(simmr_tdf_2_out, type = 'diagnostics')
plot(simmr_tdf_2_out, type = 'boxplot')
}

}
\seealso{
See \code{\link{simmr_mcmc}} for creating objects suitable for this
function, and many more examples. See also \code{\link{simmr_load}} for
creating simmr objects, \code{\link{plot.simmr_input}} for creating isospace
plots, \code{\link{plot.simmr_output}} for plotting output.
}
\author{
Andrew Parnell <andrew.parnell@mu.ie>
}
