% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep_plot.R
\name{plot_visit_med75}
\alias{plot_visit_med75}
\title{Plot patient visits against visit_med75.}
\usage{
plot_visit_med75(
  df_visit,
  df_site = NULL,
  study_id_str,
  n_sites = 6,
  min_pat_pool = 0.2,
  verbose = TRUE
)
}
\arguments{
\item{df_visit}{dataframe}

\item{df_site}{dataframe, as returned by \code{\link[=site_aggr]{site_aggr()}}}

\item{study_id_str}{character, specify study in study_id column}

\item{n_sites}{integer, Default: 6}

\item{min_pat_pool}{double, minimum ratio of available patients available for
sampling. Determines maximum visit_med75 value see Details. Default: 0.2}

\item{verbose}{logical, Default: TRUE}
}
\value{
ggplot
}
\description{
Plots cumulative AEs against visits for patients at sites of
given study and compares against visit_med75.
}
\examples{
df_visit <- sim_test_data_study(n_pat = 120, n_sites = 6,
    frac_site_with_ur = 0.4, ur_rate = 0.6)

df_visit$study_id <- "A"
df_site <- site_aggr(df_visit)

plot_visit_med75(df_visit, df_site, study_id_str = "A", n_site = 6)
}
