% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biasEliminatedCoverage.R
\name{biasEliminatedCoverage}
\alias{biasEliminatedCoverage}
\title{Calculate the bias-eliminated coverage}
\usage{
biasEliminatedCoverage(
  estimates,
  ll,
  ul,
  get = c("biasEliminatedCoverage", "biasEliminatedCoverage_mcse"),
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{estimates}{A numeric vector containing the estimates from the model(s).}

\item{ll}{A numeric vector containing the lower limits of the confidence intervals.}

\item{ul}{A numeric vector containing the upper limits of the confidence intervals.}

\item{get}{A character vector containing the values returned by the function.}

\item{na.rm}{A logical value indicating whether NA values for ll and ul should be removed before coverage estimation.}

\item{...}{Additional arguments to be ignored.}
}
\value{
A named vector containing the estimate and the Monte Carlo standard error for the coverage.
}
\description{
Estimate the bias-eliminated coverage and the Monte Carlo standard error of this estimate given a vector of confidence intervals and the true value.
}
\examples{
biasEliminatedCoverage(estimates=rnorm(4), ll=c(-1, -1, -1, -1), ul=c(1, 1, 1, -0.5))
}
