% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataInputCheck.R
\name{dataCheck}
\alias{dataCheck}
\title{Checks if data is in correct format.}
\usage{
dataCheck(data, showDetails = TRUE)
}
\arguments{
\item{data}{the input data. It can be either a list that contains a data frame in .$timeIntensityData or can be a data frame by itself.}

\item{showDetails}{logical, if TRUE the function will provide an output "check done" if everything is OK. Default is FALSE}
}
\description{
Checks if the input data is appropriate and if it is not, the function converts it into a suitable form. The input data frame should contain two columns named time and intensity related to time variable and intensity variable respectively. If the data frame is in a list its name in the list should be $timeIntensityData.
}
\examples{

# Example 1

# generate data frame
time <- seq(3, 48, 0.5)
intensity <- runif(length(time), 3.0, 7.5)
dataInput <- data.frame(time, intensity)

# Apply dataCheck function
dataOutputVariable <- dataCheck(dataInput)

# Example 2

# generate data frame
time <- seq(3, 48, 0.5)
intensity <- runif(length(time), 3.0, 7.5)
dataInput <- data.frame(time, intensity)

# Normalize Data
dataOutput <- normalizeData(dataInput)
dataInput2 <- dataOutput

# Apply dataCheck function
dataOutputVariable2 <- dataCheck(dataInput2)
}
