% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/migrate-shinytest-dir.R
\name{migrateShinytestDir}
\alias{migrateShinytestDir}
\title{Migrate legacy \pkg{shinytest} files to new test directory structure}
\usage{
migrateShinytestDir(appdir, dryrun = FALSE)
}
\arguments{
\item{appdir}{A directory containing a Shiny application.}

\item{dryrun}{If \code{TRUE}, print out the changes that would be made, but don't
actually do them.}
}
\description{
This function migrates the old-style directory structure used by
\pkg{shinytest} (versions 1.3.1 and below) to new test directory structure
used in shinytest 1.4.0 and above.
}
\details{
Before \pkg{shinytest} 1.4.0, the shinytest scripts and results were put in a
subdirectory of the application named \verb{tests/}. As of \pkg{shinytest} 1.4.0,
the tests are put in \verb{tests/shinytest/}, so that it works with the
\code{runTests()} function shiny package (added in \pkg{shiny} 1.5.0).

With \pkg{shinytest} 1.3.1 and below, the tests/ subdirectory of the
application was used specifically for \pkg{shinytest}, and could not be used
for other types of tests. So the directory structure would look like this:\preformatted{appdir/
 `- tests
     `- mytest.R
}

In Shiny 1.5.0, the \code{shiny::runTests()} function was added, and it will run
test scripts tests/ subdirectory of the application. This makes it possible
to use other testing systems in addition to shinytest. \pkg{shinytest} 1.4.0
is designed to work with this new directory structure. The directory
structure looks something like this:\preformatted{appdir/
 |- R
 |- tests
     |- shinytest.R
     |- shinytest
     |   `- mytest.R
     |- testthat.R
     `- testthat
         `- test-script.R
}

This allows for tests using the \pkg{shinytest} package as well as other
testing tools, such as the \code{shiny::testServer()} function, which can be used
for testing module and server logic, and for unit tests of functions in an R/
subdirectory.

In \pkg{shinytest} 1.4.0 and above, it defaults to creating the new directory
structure.
}
