% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_tools.R
\name{add_file_in_dir}
\alias{add_file_in_dir}
\alias{edit_file_in_dir}
\alias{suppress_file_in_dir}
\title{Add / suppress / edit a file}
\usage{
add_file_in_dir(file, dir, yml, name, description = "")

edit_file_in_dir(id, dir, yml, name = NULL, description = NULL, file = NULL)

suppress_file_in_dir(id, dir, yml)
}
\arguments{
\item{file}{\code{character} file (to copy) path.}

\item{dir}{\code{character} directory path.}

\item{yml}{\code{character} yaml file path.}

\item{name}{\code{character} file name.}

\item{description}{\code{character} file description.}

\item{id}{\code{character} file id in yaml.}
}
\value{
These functions return a \code{logical} indicating if operation succeeded or not
}
\description{
Add / suppress / edit a file
}
\examples{
\dontrun{

yml <- file.path(getwd(), "test_sfm/config.yml") # will be created

dir <- file.path(getwd(), "test_sfm")
dir.create(dir)

file <- system.file("translate/translate.csv", package = "shinydrive")

# add one first file
add_file_in_dir(
  file = file,
  dir= dir,
  yml = yml,
  name = "translate1",
  description = ""
)

yaml::yaml.load_file(yml)
list.files(dir)

# add second file
add_file_in_dir(
  file = file,
  dir= dir,
  yml = yml,
  name = "translate_2",
  description = "This is cool"
)

yaml::yaml.load_file(yml)
list.files(dir)

# modify first file
edit_file_in_dir(
  id = "2", dir = dir, yml = yml,
  name = "translate_2_mod",
  description = "So cool"
)

yaml::yaml.load_file(yml)
list.files(dir)

# suppress first file
suppress_file_in_dir(id = "1", dir = dir, yml = yml)

yaml::yaml.load_file(yml)
list.files(dir)

}

}
