% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{progressBar}
\alias{progressBar}
\title{AdminLTE2 vertical progress bar}
\usage{
progressBar(
  value,
  min = 0,
  max = 100,
  vertical = FALSE,
  striped = FALSE,
  animated = FALSE,
  status = "primary",
  size = NULL,
  label = NULL
)
}
\arguments{
\item{value}{Progress bar value. Must be between min and max.}

\item{min}{Progress bar minimum value (0 by default).}

\item{max}{Progress bar maximum value (100 by default).}

\item{vertical}{Progress vertical layout. Default to FALSE}

\item{striped}{Whether the progress is striped or not. FALSE by default.}

\item{animated}{Whether the progress is active or not. FALSE by default.
Works only if striped is TRUE.}

\item{status}{Progress bar status. "primary" by default or "warning", "info",
"danger" or "success".
Valid statuses are defined as follows:
\itemize{
  \item \code{primary}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#3c8dbc")}
  \item \code{success}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#00a65a")}
  \item \code{info}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#00c0ef")}
  \item \code{warning}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#f39c12")}
  \item \code{danger}: \Sexpr[results=rd, stage=render]{shinydashboardPlus:::rd_color_tag("#f56954")}
}}

\item{size}{Progress bar size. NULL by default: "sm", "xs" or "xxs" also available.}

\item{label}{Progress label. NULL by default.}
}
\description{
This creates a vertical progress bar.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 
 shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(
      box(
       title = "Horizontal",
       progressBar(
        value = 10,
        striped = TRUE,
        animated = TRUE,
        label = "10\%"
       ),
       progressBar(
        value = 50,
        status = "warning",
        size = "xs"
       ),
       progressBar(
        value = 20,
        status = "danger",
        size = "sm"
       )
      ),
      box(
       title = "Vertical",
       progressBar(
        value = 10,
        striped = TRUE,
        animated = TRUE,
        vertical = TRUE
       ),
       progressBar(
        value = 50,
        status = "warning",
        size = "xs",
        vertical = TRUE
       ),
       progressBar(
        value = 20,
        status = "danger",
        size = "sm",
        vertical = TRUE
       )
      )
     ),
     title = "Progress bars"
   ),
   server = function(input, output) { }
 )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
