% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/card-tabset.R
\name{card_tabset}
\alias{card_tabset}
\title{Generates a set of card panels}
\usage{
card_tabset(
  ...,
  inputId = rand_string(prefix = "tabset-"),
  title = NULL,
  names = NULL,
  active = NULL,
  tools = NULL,
  footer = NULL,
  class = "",
  class_header = "",
  class_body = "",
  class_foot = ""
)
}
\arguments{
\item{...}{'HTML' tags; each tag will be placed into a card}

\item{inputId}{the id of the card-set, must start with letters}

\item{title}{the title of the card-set}

\item{names}{title of the tabs}

\item{active}{the title that will be active on load}

\item{tools}{a list of tools or badges generated by
\code{\link{card_tool}} or \code{\link{as_badge}}}

\item{footer}{the footer element of the card-set}

\item{class}{the 'HTML' class the of card-set}

\item{class_header, class_body, class_foot}{additional 'HTML'
class the of card header, body, and footer accordingly}
}
\value{
'HTML' tags
}
\description{
To insert, remove, or active card panels, see
\code{\link{card_tabset_operate}}.
}
\examples{

library(shiny)
library(shidashi)

# Fake session to operate on card_tabset without shiny
session <- MockShinySession$new()

card_tabset(
  inputId = "card_set",
  title = "Cardset with Tools",
  `Tab 1` = p("Tab content 1"),
  class_body = "height-500",
  tools = list(
    as_badge(
      "New|badge-success"
    ),
    card_tool(
      widget = "collapse"
    ),
    card_tool(
      widget = "maximize"
    )
  )
)

card_tabset_insert(
  inputId = "card_set",
  title = "Tab 2",
  p("New content"),
  session = session
)

card_tabset_activate(
  inputId = "card_set",
  title = "Tab 1",
  session = session
)

card_tabset_remove(
  inputId = "card_set",
  title = "Tab 2",
  session = session
)



}
\seealso{
\code{\link{card_tabset_operate}}
}
