#' Calculates the shattering coefficient for a decision tree.
#'
#' @description Using a recursion function as auxiliar function,
#' calculates the shattering coefficient for a rpart decision tree.
#'
#' @param rpart.tree rpart.tree. A Decision tree generated by rpart package.
#' @param n_samples int. The # of samples to consider in dataset.
#'
#' @usage compute_shattering(rpart.tree, n_samples)
#'
#' @return The calculus of the shattering coefficient.
#'
#' @export compute_shattering
compute_shattering <- function(rpart.tree, n_samples){
    if(exists("rpart.tree")){
        root = as.integer(rownames(rpart.tree$frame))[1]
        left_children = root*2
        right_children = (root*2)+1
        samples = rpart.tree$frame$wt
        node_type = rpart.tree$frame$var
        nodes = as.integer(rownames(rpart.tree$frame))

        shattering <- recurse(nodes, left_children, right_children, root, NULL, samples, node_type, NULL, n_samples)

        return (shattering)
    }
    stop("There is no rpart.tree object.")
}
