% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygonAdjacency.R
\name{polygonAdjacency}
\alias{polygonAdjacency}
\title{Summarize Spatial Adjacency of Polygon Fabric}
\usage{
polygonAdjacency(x, v = "MUSYM", ...)
}
\arguments{
\item{x}{\code{sf} object containing simple polygon features, some of which should share edges}

\item{v}{character, name of column in attribute table describing map unit labels}

\item{...}{additional arguments passed to \code{\link[spdep:poly2nb]{spdep::poly2nb()}}}
}
\value{
a \code{list} containing:
\itemize{
\item \code{commonLines}: an integer vector of feature IDs, describing polygons sharing edges and values of \code{v} (map unit labels)
\item \code{adjMat}: weighted adjacency matrix, suitable for visualization with  \code{\link[=plotSoilRelationGraph]{plotSoilRelationGraph()}}
}
}
\description{
This function utilizes the \code{spdep} and \code{igraph} packages to evaluate several measures of spatial connectivity.
}
\details{
Examples are presented in \href{http://ncss-tech.github.io/AQP/sharpshootR/common-soil-lines.html}{this tutorial}.
}
\author{
D.E. Beaudette
}
