% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotWB_lines.R
\name{plotWB_lines}
\alias{plotWB_lines}
\title{Line / Area Visualization for Monthly Water Balance}
\usage{
plotWB_lines(
  WB,
  cols = c("#759CC9", "#EB6D6E", "#7FC47D"),
  line.col = "black",
  line.lty = c(1, 2, 3),
  interpolator = c("spline", "linear"),
  spline.method = c("natural", "periodic"),
  month.cex = 1
)
}
\arguments{
\item{WB}{output from \code{\link[=monthlyWB]{monthlyWB()}}}

\item{cols}{vector of three colors used for area under PPT, PET, and AET curves}

\item{line.col}{single color used for PPT, PET, and AET lines}

\item{line.lty}{vector of three line styles used for PPT, PET, AET curves}

\item{interpolator}{spline or linear interpolation of monthly values, use of \code{spline} may lead to minor smoothing artifacts in shaded areas}

\item{spline.method}{when \code{interpolator = 'spline'}, argument passed to \code{splinefun(..., method = spline.method)}}

\item{month.cex}{scaling factor for month labels}
}
\value{
nothing, function is called to generate graphical output
}
\description{
Line / Area Visualization for Monthly Water Balance
}
\examples{

if(requireNamespace('hydromad')) {

## A shallow / droughty soil near Sonora CA 
# 100mm (4") AWC
AWC <- 100
PPT <- c(171, 151, 138, 71, 36, 7, 1, 2, 11, 48, 102, 145)
PET <- c(15.17, 18.26, 30.57, 42.95, 75.37, 108.05, 139.74, 128.9, 93.99, 59.84, 26.95, 14.2)

# calendar-year
# three year warm-up
x.wb <- monthlyWB(AWC, PPT, PET, S_init = 0, starting_month = 1, rep = 3, keep_last = TRUE)
 
# plot
plotWB_lines(x.wb)

}

}
\author{
J.M. Skovlin and D.E. Beaudette
}
