% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection_performance.R
\name{ClusteringPerformance}
\alias{ClusteringPerformance}
\title{Clustering performance}
\usage{
ClusteringPerformance(theta, theta_star, ...)
}
\arguments{
\item{theta}{output from \code{\link{Clustering}}. Alternatively, it can be
the estimated co-membership matrix (see \code{\link{CoMembership}}).}

\item{theta_star}{output from \code{\link[fake]{SimulateClustering}}.Alternatively,
it can be the true co-membership matrix (see \code{\link{CoMembership}}).}

\item{...}{additional arguments to be passed to \code{\link{Clusters}}.}
}
\value{
A matrix of selection metrics including:

  \item{TP}{number of True Positives (TP)} \item{FN}{number of False
  Negatives (TN)} \item{FP}{number of False Positives (FP)} \item{TN}{number
  of True Negatives (TN)} \item{sensitivity}{sensitivity, i.e. TP/(TP+FN)}
  \item{specificity}{specificity, i.e. TN/(TN+FP)} \item{accuracy}{accuracy,
  i.e. (TP+TN)/(TP+TN+FP+FN)} \item{precision}{precision (p), i.e.
  TP/(TP+FP)} \item{recall}{recall (r), i.e. TP/(TP+FN)}
  \item{F1_score}{F1-score, i.e. 2*p*r/(p+r)} \item{rand}{Rand Index, i.e.
  (TP+TN)/(TP+FP+TN+FN)} \item{ari}{Adjusted Rand Index (ARI), i.e.
  2*(TP*TN-FP*FN)/((TP+FP)*(TN+FP)+(TP+FN)*(TN+FN))} \item{jaccard}{Jaccard
  index, i.e. TP/(TP+FP+FN)}
}
\description{
Computes different metrics of clustering performance by comparing true and
predicted co-membership. This function can only be used in simulation studies
(i.e. when the true cluster membership is known).
}
\examples{
\donttest{
# Data simulation
set.seed(1)
simul <- SimulateClustering(
  n = c(30, 30, 30), nu_xc = 1
)
plot(simul)

# Consensus clustering
stab <- Clustering(
  xdata = simul$data, nc = seq_len(5)
)

# Clustering performance
ClusteringPerformance(stab, simul)

# Alternative formulation
ClusteringPerformance(
  theta = CoMembership(Clusters(stab)),
  theta_star = simul$theta
)
}

}
\seealso{
Other functions for model performance: 
\code{\link{SelectionPerformance}()},
\code{\link{SelectionPerformanceGraph}()}
}
\concept{functions for model performance}
