% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapley_setup.R
\name{exact_coalition_table}
\alias{exact_coalition_table}
\title{Get table with all (exact) coalitions}
\usage{
exact_coalition_table(
  m,
  max_fixed_coal_size = ceiling((m - 1)/2),
  dt_valid_causal_coalitions = NULL,
  weight_zero_m = 10^6
)
}
\arguments{
\item{m}{Positive integer.
Total number of features/groups.}

\item{dt_valid_causal_coalitions}{data.table. Only applicable for asymmetric Shapley
values explanations, and is \code{NULL} for symmetric Shapley values.
The data.table contains information about the coalitions that respects the causal ordering.}

\item{weight_zero_m}{Numeric.
The value to use as a replacement for infinite coalition weights when doing numerical operations.}
}
\description{
Get table with all (exact) coalitions
}
\keyword{internal}
