% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_coobs.R
\name{calculate_coobs}
\alias{calculate_coobs}
\title{coobs algorithm sampling}
\usage{
calculate_coobs(
  mraster,
  existing,
  cores = 1,
  threshold = 0.95,
  plot = FALSE,
  filename = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{mraster}{spatRaster. ALS metrics raster. Requires at least 2 layers to calculate covariance matrix.}

\item{existing}{sf 'POINT'.  Existing plot network.}

\item{cores}{Numeric. Number of cores to use for parallel processing. \code{default = 1}.}

\item{threshold}{Numeric. Proxy maximum pixel quantile to avoid outliers. \code{default = 0.95}.}

\item{plot}{Logical. Plots output strata raster and visualized
strata with boundary dividers.}

\item{filename}{Character. Path to write stratified raster to disc.}

\item{overwrite}{Logical. Specify whether \code{filename} should be overwritten on disc.}
}
\value{
Output raster with coobs and classified coobs layers.
}
\description{
Perform the COunt of OBServations (coobs) algorithm using existing site data
and raster metrics. This algorithm aids the user in determining where additional samples
could be located by comparing existing samples to each pixel and associated covariates.
The output coobs raster could be used to constrain clhs sampling to areas that are underreprented.
}
\note{
Special thanks to Dr. Brendan Malone for the original implementation of this algorithm.
}
\examples{
\dontrun{
#--- Load raster and existing plots---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")
mr <- terra::rast(r)

e <- system.file("extdata", "existing.shp", package = "sgsR")
e <- sf::st_read(e)

calculate_coobs(
  mraster = mr,
  existing = e,
  cores = 4
)
}
}
\references{
Malone BP, Minasny B, Brungard C. 2019. Some methods to improve the utility of conditioned Latin hypercube sampling. PeerJ 7:e6451 DOI 10.7717/peerj.6451
}
\seealso{
Other calculate functions: 
\code{\link{calculate_allocation}()},
\code{\link{calculate_allocation_existing}()},
\code{\link{calculate_distance}()},
\code{\link{calculate_pcomp}()},
\code{\link{calculate_pop}()},
\code{\link{calculate_representation}()},
\code{\link{calculate_sampsize}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{calculate functions}
