% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toy_data_gen.R
\name{generate_toy_data}
\alias{generate_toy_data}
\title{generate toy data}
\usage{
generate_toy_data(
  p,
  n,
  rho = 0,
  seed_id = 2,
  grouped = TRUE,
  groups,
  noise_level = 1,
  group_sparsity = 0.1,
  var_sparsity = 0.5,
  orthogonal = FALSE,
  data_mean = 0,
  data_sd = 1,
  signal_mean = 0,
  signal_sd = sqrt(10)
)
}
\arguments{
\item{p}{The number of input variables.}

\item{n}{The number of observations.}

\item{rho}{Correlation coefficient. Must be in range \eqn{[0,1]}.}

\item{seed_id}{Seed to be used to generate the data matrix \eqn{X}.}

\item{grouped}{A logical flag indicating whether grouped data is required.}

\item{groups}{If item{grouped=TRUE}, the grouping structure is required. Each input variable should have a group id.}

\item{noise_level}{Defines the level of noise (\eqn{sigma}) to be used in generating the response vector \eqn{y}.}

\item{group_sparsity}{Defines the level of group sparsity. Must be in the range \eqn{[0,1]}.}

\item{var_sparsity}{Defines the level of variable sparsity. Must be in the range \eqn{[0,1]}. If \code{grouped=TRUE}, this defines the level of sparsity within each group, not globally.}

\item{orthogonal}{Logical flag as to whether the input matrix should be orthogonal.}

\item{data_mean}{Defines the mean of input predictors.}

\item{data_sd}{Defines the standard deviation of the signal (\eqn{beta}).}

\item{signal_mean}{Defines the mean of the signal (\eqn{beta}).}

\item{signal_sd}{Defines the standard deviation of the signal (\eqn{beta}).}
}
\value{
A list containing:
\item{y}{The response vector.}
\item{X}{The input matrix.}
\item{true_beta}{The true values of \eqn{beta} used to generate the response.}
\item{true_grp_id}{Indices of which groups are non-zero in item{true_beta}.}
}
\description{
Generates different types of datasets, which can then be fitted using sparse-group SLOPE.
}
\details{
The data is generated under a Gaussian linear model. The generated data can be grouped and sparsity can be provided at both a group and/or variable level.
}
\examples{
# specify a grouping structure
groups = c(rep(1:20, each=3),
          rep(21:40, each=4),
          rep(41:60, each=5),
          rep(61:80, each=6),
          rep(81:100, each=7))
# generate data
data = generate_toy_data(p=500, n=400, groups = groups, seed_id=3)

}
