\name{lagplot}
\title{Lag Scatter Plot}
\usage{lagplot(point.obj, pair.obj, a1, a2=a1, lag=1, std=F, query.a, xlim, ylim)}
\alias{lagplot}
\arguments{
\item{point.obj}{a point object generated by \code{point()}}
\item{pair.obj}{a pair object generated by \code{pair()}}
\item{a1}{a variable to plot}
\item{a2}{an optional variable name, if entered the plot will be created between \code{a1} and \code{a2}}
\item{lag}{the lag to plot} 
\item{std}{a logical variable indicating whether the data should be standardized to their means and standard deviations before
plotting}
\item{query.a}{an optional variable name, if entered, the value of the variable will be displayed on the graphics device for points
identified by the user.}
\item{xlim}{a vector of length 2 indicating the x limits of the graphics page}
\item{ylim}{a vector of length 2 indicating the y limits of the graphics page}
}
\value{NULL}
\description{Create a spatially lagged scatter plot, e.g. plot z(s) versus z(s+h), where h is a lag in a pair object. }
\note{When \code{query.a} is entered, the user will be prompted to identify points on the display device. Because each point in the
plot represents a pair of locations, the user must identify each point twice, once for the "from" point and once for the "to"
point. Querying is ended by pressing the middle mouse button on the mouse while the cursor is in the display window. }
\seealso{\code{\link{point}}, \code{\link{pair}}}
\examples{
\testonly{
# prepare variables from other example pages if they are not already there:
if(length(ls(pat="maas.pair"))==0){example(pair)}
}
opar <- par(ask = interactive() && .Device == "X11")
lagplot(maas.point,maas.pair,'zinc')
# with identifying pairs:
lagplot(maas.point,maas.pair,'zinc',lag=2,query.a='zinc')
par(opar)
}
\references{
http://www.gis.iastate.edu/SGeoStat/homepage.html
}
\keyword{spatial}
